﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class MissionsConfiguration : ConfigurationElement
{
    public int MissionSpawnChunkSize { get; private set; }
    public float MissionSpawnChunkDelayTime { get; private set; }
    public int MissionsPerChunk { get; private set; }
    public MissionsCoreConfiguration Core { get; private set; }
    public TimeTrialConfiguration TimeTrial { get; private set; }
    public CollectionConfiguration Collection { get; private set; }
    public WagerRaceConfiguration WagerRace { get; private set; }

    public MissionsConfiguration() : base("Missions")
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            MissionSpawnChunkSize = Convert.ToInt32(configElem.Element("MissionSpawnChunkSize").Value);
            MissionSpawnChunkDelayTime = Convert.ToSingle(configElem.Element("MissionSpawnChunkDelayTime").Value);
            MissionsPerChunk = Convert.ToInt32(configElem.Element("MissionsPerChunk").Value);

            //Create our sub-configuration objects
            Core = new MissionsCoreConfiguration();
            TimeTrial = new TimeTrialConfiguration();
            Collection = new CollectionConfiguration();
            WagerRace = new WagerRaceConfiguration();

            //Let's try to parse all of our sub configurations, passing in the corresponding parent elements
            if (Core.Parse(configElem.Element("Core")))
            {
                if (TimeTrial.Parse(configElem.Element("TimeTrial")))
                {
                    if (Collection.Parse(configElem.Element("Collection")))
                    {
                        if (WagerRace.Parse(configElem.Element("WagerRace")))
                        {
                            return true;    //Parsed everything successfully!
                        }

                        else
                        {
                            Debug.LogError("ERROR: Failed to parse wager race configuration.");
                        }
                    }

                    else
                    {
                        Debug.LogError("ERROR: Failed to parse collection configuration.");
                    }
                }

                else
                {
                    Debug.LogError("ERROR: Failed to parse time trial configuration.");
                }
            }

            else
            {
                Debug.LogError("ERROR: Failed to parse missions core configuration.");
            }

            return false;   //We must have failed to parse one of the configurations
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing missions configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
